package w83a.w83aDAO;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import w83a.util.jdbc.W83aDataBase;
import w83a.w83aBeans.W83aDatosFasesTramitesBean;
import w83a.w83aBeans.W83aDocBean;
import w83a.w83aBeans.W83aDocBeanImpug;
import w83a.w83aBeans.W83aHistorialImpugnacionBean;
import w83a.w83aBeans.W83aImpugnacionBean;
import w83a.w83aBeans.W83aSindicatosBean;
import w83a.w83aBeans.W83aTipoDocumentoBean;
import w83a.w83aBeans.W83aTramiteImpugnacionBean;
import w83a.w83aBeans.W83aUsuarioXLNetsBean;
import w83a.w83aDAO.w83aConstantesBD.W83aFasesBD;
import w83a.w83aDAO.w83aConstantesBD.W83aImpugnacionesBD;
import w83a.w83aDAO.w83aConstantesBD.W83aImpugnacionesVistaBD;
import w83a.w83aDAO.w83aConstantesBD.W83aPreavisosBD;
import w83a.w83aDAO.w83aConstantesBD.W83aSindicatosBD;
import w83a.w83aDAO.w83aConstantesBD.W83aSindicatosImpugnacionBD;
import w83a.w83aDAO.w83aConstantesBD.W83aTiposDocumentosVistaBD;
import w83a.w83aDAO.w83aConstantesBD.W83aTramitesBD;
import w83a.w83aUtilidadesComunes.W83aClsConstantes;
import w83a.w83aUtilidadesComunes.W83aDateUtil;

// TODO: Auto-generated Javadoc
/**
 * The Class W83aImpugnacionesDAO.
 * @author a
 */
public class W83aImpugnacionesDAO implements W83aIImpugnacionesDAO {
	/* (non-Javadoc)
	 * @see w83a.w83aDAO.W83aIImpugnacionesDAO#cargaTiposDocumento(java.util.HashMap)
	 */
	public List cargaTiposDocumento(HashMap param) throws Exception {
		List listaFasesTramites=new ArrayList();
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		W83aDatosFasesTramitesBean datos;
		List lista=new ArrayList();
		if (param.get("numImpugnacion")!=null)
		{
			//tengo que sacar los tramites y fases por los que ha pasado el preaviso
			
			strSql.append("SELECT ");
			strSql.append(W83aImpugnacionesBD.c_fase_071);
			strSql.append(",");
			strSql.append(W83aImpugnacionesBD.c_tram_071);
			strSql.append(" FROM ");
			strSql.append(W83aImpugnacionesBD.tramitesImpugView);
			strSql.append(" WHERE ");
			strSql.append(W83aImpugnacionesBD.n_impug_071).append(" = ?");
			strSql.append(" AND ");
			strSql.append(W83aImpugnacionesBD.ano_impug_071).append(" = ?");
			strSql.append(" AND ");
			strSql.append(W83aImpugnacionesBD.c_territ_071).append(" = ?");
			strSql.append(" ORDER BY ");
			strSql.append(W83aImpugnacionesBD.c_tram_071).append(" DESC");
			String [] numImpug=((String)param.get("numImpugnacion")).split("_");
			
			params.add(new Integer(numImpug[2]));
			params.add(new Integer(numImpug[1]));
			params.add(numImpug[0]);
			
			listaFasesTramites=W83aDataBase.executeQuery(strSql.toString(),params,W83aDatosFasesTramitesBean.class,null, "impugnaciones");
			
			if(listaFasesTramites==null || listaFasesTramites.isEmpty())
			{
				datos=new W83aDatosFasesTramitesBean();
				datos.setCodFase(String.valueOf(W83aClsConstantes.CINCO));
				datos.setCodTramite(String.valueOf(W83aClsConstantes.UNO));
				lista.add(datos);
				datos=new W83aDatosFasesTramitesBean();
				datos.setCodFase(String.valueOf(W83aClsConstantes.CINCO));
				datos.setCodTramite(String.valueOf(W83aClsConstantes.NOVENTAYNUEVE));
				lista.add(datos);
			}else{
				boolean laudo=false;
				for(int i=0;i<listaFasesTramites.size()&& !laudo;i++)
				{
					if(((W83aDatosFasesTramitesBean)listaFasesTramites.get(i)).getCodTramite().equals(String.valueOf(W83aClsConstantes.CUATRO))
							|| ((W83aDatosFasesTramitesBean)listaFasesTramites.get(i)).getCodTramite().equals(String.valueOf(W83aClsConstantes.UNO)))
					{
						lista.add(((W83aDatosFasesTramitesBean)listaFasesTramites.get(i)));
						laudo=true;
						datos=new W83aDatosFasesTramitesBean();//NOPMD
						datos.setCodFase(String.valueOf(W83aClsConstantes.CINCO));
						datos.setCodTramite(String.valueOf(W83aClsConstantes.NOVENTAYNUEVE));
						lista.add(datos);
					}
				}
				
			}
		}
		else
		{
			 datos=new W83aDatosFasesTramitesBean();
			datos.setCodFase(String.valueOf(W83aClsConstantes.CINCO));
			datos.setCodTramite(String.valueOf(W83aClsConstantes.UNO));
			lista.add(datos);
			datos=new W83aDatosFasesTramitesBean();
			datos.setCodFase(String.valueOf(W83aClsConstantes.CINCO));
			datos.setCodTramite(String.valueOf(W83aClsConstantes.NOVENTAYNUEVE));
			lista.add(datos);
		}
		//obtengo los documentos
		strSql = new StringBuffer();
		params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83aTiposDocumentosVistaBD.tipoDocFasTram);
		strSql.append(",");
		strSql.append(W83aTiposDocumentosVistaBD.fase);
		strSql.append(",");
		strSql.append(W83aTiposDocumentosVistaBD.tramite);
		strSql.append(",");
		if (param.get("strIdioma").equals(W83aClsConstantes.CONSTANTE_CASTELLANO))
		{
				strSql.append(W83aTiposDocumentosVistaBD.descFase).append(" AS DESCFASE , ");
				strSql.append(W83aTiposDocumentosVistaBD.descTramite).append(" AS DESCTRAMITE, ");
				strSql.append(W83aTiposDocumentosVistaBD.descTipoDoc).append(" AS DESCRIPCION ");
		}else{
				strSql.append(W83aTiposDocumentosVistaBD.deseFase).append(" AS DESCFASE , ");
				strSql.append(W83aTiposDocumentosVistaBD.deseTramite).append(" AS DESCTRAMITE, ");
				strSql.append(W83aTiposDocumentosVistaBD.deseTipoDoc).append(" AS DESCRIPCION ");
			}
		
		strSql.append(" FROM w83b.");
		strSql.append(W83aTiposDocumentosVistaBD.vista);
		strSql.append(" WHERE ");
		strSql.append(W83aTiposDocumentosVistaBD.tramite).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aTiposDocumentosVistaBD.fase).append(" = ?");
		W83aDatosFasesTramitesBean datosFases=null;
		List listaTiposDocsAux=null;
		List listaTiposDocsResult=new ArrayList();
		for (int i=0;i<lista.size();i++)
		{
			datosFases=(W83aDatosFasesTramitesBean)lista.get(i);
			params.add(new Integer(datosFases.getCodTramite()));//NOPMD
			params.add(new Integer(datosFases.getCodFase()));//NOPMD
			listaTiposDocsAux=W83aDataBase.executeQuery(strSql.toString(),params,W83aTipoDocumentoBean.class,null, "impugnaciones");
			for (int j=0;j<listaTiposDocsAux.size();j++)
			{
				listaTiposDocsResult.add(listaTiposDocsAux.get(j));
			}
			params.clear();
		}
		
		return listaTiposDocsResult;
	}
	
	/* (non-Javadoc)
	 * @see w83a.w83aDAO.W83aIImpugnacionesDAO#obtenerDatosBasicosImpugnacion(java.lang.String, w83a.w83aBeans.W83aUsuarioXLNetsBean)
	 */
	public W83aImpugnacionBean obtenerDatosBasicosImpugnacion(String codSelec,String idioma, W83aUsuarioXLNetsBean usuarioBean) throws Exception {
		
		String [] cod=codSelec.split("_");
		
		// TODO Auto-generated method stub
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83aImpugnacionesVistaBD.NIMPUGNACION).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.codTerritorioImpugnacion).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.anyoImpugnacion).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.numImpugnacion).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.NPREAVISO).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.anyoPreaviso).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.numPreaviso).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.anyoActa).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.numActa).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.VERSION).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.NACTA).append(", TO_CHAR(");
		strSql.append(W83aImpugnacionesVistaBD.fimpugnacionDate).append(",?) AS ").append(W83aImpugnacionesVistaBD.FIMPUGNACION).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.NOMBREARBITRO).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.ARBITRO).append(", TO_CHAR(");
		strSql.append(W83aImpugnacionesVistaBD.fenvioarbitroDate).append(",?) AS ").append(W83aImpugnacionesVistaBD.FENVIOARBITRO).append(", TO_CHAR(");
		strSql.append(W83aImpugnacionesVistaBD.fdesestimientoDate).append(",?) AS ").append(W83aImpugnacionesVistaBD.FDESESTIMIENTO).append(", TO_CHAR(");
		strSql.append(W83aImpugnacionesVistaBD.fenviojuzgadoDate).append(",?) AS ").append(W83aImpugnacionesVistaBD.FENVIOJUZGADO).append(", TO_CHAR(");
		strSql.append(W83aImpugnacionesVistaBD.fsentenciaDate).append(",?) AS ").append(W83aImpugnacionesVistaBD.FSENTENCIA).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.asunto).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.decision).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.anyoLaudo).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.numLaudo).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.NLAUDO).append(", TO_CHAR(");
		strSql.append(W83aImpugnacionesVistaBD.flaudoDate).append(",?) AS ").append(W83aImpugnacionesVistaBD.FLAUDO).append(", ");
		
		strSql.append(W83aImpugnacionesVistaBD.RESULTADO).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.DESCRESULTADO).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.DESERESULTADO).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.TIPOIMPUG).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.DESETIPOIMPUG).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.DESCTIPOIMPUG).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.NREGISTRO).append(", TO_CHAR(");
		strSql.append(W83aImpugnacionesVistaBD.fregistroDate).append(",?) AS ").append(W83aImpugnacionesVistaBD.FREGISTRO).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.CODVOCES).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.DESCVOCES).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.DESEVOCES).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.CODSINDICATOS).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.DESCSINDICATOS).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.NCENTRO).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.RAZONSOCIAL).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.codProvincia).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.codMunicipio).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.centroProvinciaTxtC).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.centroProvinciaTxtE).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.centroMunicipioTxtC).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.centroMunicipioTxtE).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.IDCENTRO).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.CIF).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.DNIIMPUG).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.NOMBREIMPUG).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.DIRIMPUG).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.CPIMPUG).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.MUNIIMPUG).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.MUNIIMPUGTXTC).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.PROVIMPUGTXTC).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.MUNIIMPUGTXTE).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.PROVIMPUGTXTE).append(", ");
		strSql.append(W83aImpugnacionesVistaBD.PROVIMPUG);

		
		
		strSql.append(" FROM w83b.").append(W83aImpugnacionesVistaBD.impugnacionesView);
		
		strSql.append(" WHERE ").append(W83aImpugnacionesVistaBD.codTerritorioImpugnacion).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aImpugnacionesVistaBD.anyoImpugnacion).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aImpugnacionesVistaBD.numImpugnacion).append(" = ?");
		
			
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(idioma));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(idioma));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(idioma));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(idioma));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(idioma));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(idioma));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(idioma));
		
		params.add(new String(cod[0]));		
		params.add(new Integer(cod[1]));
		params.add(new Integer(cod[2]));
		
		
		List lista = W83aDataBase.executeQuery(strSql.toString(),params,W83aImpugnacionBean.class,null, null);
		((W83aImpugnacionBean)lista.get(0)).setCodSelec(codSelec);
		
		/*CallableStatement cs;
		cs = W83aDataBase.getConnection().prepareCall("{call w83a.w83aHistorialImpugnaciones(?,?,?,?,?,?,?)}");
		cs.setInt(1, Integer.parseInt(cod[2]));
		cs.setInt(2, Integer.parseInt(cod[1]));
		cs.setString(3, cod[0]);
		 cs.setString(4, W83aDateUtil.getInstance().getCurrentDateTime(W83aDateUtil.ES_PATTERN_HORA));
	    cs.setString(5, usuarioBean.getIdUsuario());
		cs.setString(6,Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun", "comun.historial.accesoimpugnacion", W83aClsConstantes.CONSTANTE_CASTELLANO));
		cs.setString(7,Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun", "comun.historial.accesoimpugnacion", W83aClsConstantes.CONSTANTE_EUSKARA));
		cs.execute();*/
		return ((W83aImpugnacionBean)lista.get(0));
}
	
	/* (non-Javadoc)
	 * @see w83a.w83aDAO.W83aIImpugnacionesDAO#obtenerTramitesImpugnacion(java.lang.String)
	 */
	public W83aImpugnacionBean obtenerTramitesImpugnacion(String codSelec,String idioma)
	throws Exception {
		
		String [] cod=codSelec.split("_");
		
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		
		strSql.append(W83aImpugnacionesBD.cod_fase).append(", ");
		strSql.append(W83aImpugnacionesBD.desc_fase).append (" AS DESC_FASE").append(", ");
		strSql.append(W83aImpugnacionesBD.dese_fase).append (" AS DESE_FASE").append(", ");
		strSql.append(W83aImpugnacionesBD.desc_tramite).append (" AS DESC_TRAMITE").append(", ");
		strSql.append(W83aImpugnacionesBD.dese_tramite).append (" AS DESE_TRAMITE").append(", TO_CHAR(");
		strSql.append(W83aImpugnacionesBD.f_actu_tramite).append(",?) AS "+W83aImpugnacionesBD.f_actu_tramite+", ");
		strSql.append(W83aImpugnacionesBD.usu_alta).append(", TO_CHAR(");
		strSql.append(W83aImpugnacionesBD.fecha_alta_tramite).append(",?) AS "+W83aImpugnacionesBD.fecha_alta_tramite+", ");
		strSql.append(W83aImpugnacionesBD.usu_mod).append(",  TO_CHAR(");
		strSql.append(W83aImpugnacionesBD.fecha_mod).append(",?) AS "+W83aImpugnacionesBD.fecha_mod+", ");
		strSql.append(W83aImpugnacionesBD.fecha_reg_salida).append(", ");
		strSql.append(W83aImpugnacionesBD.num_reg_salid);
		

		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(idioma));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(idioma));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(idioma));
		
		strSql.append(" FROM w83b.").append(W83aImpugnacionesBD.vista_historial_tramitacion);
		
		strSql.append(" WHERE ").append(W83aImpugnacionesBD.codTerritorio).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aImpugnacionesBD.anyo_impug).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aImpugnacionesBD.num_impug).append(" = ?");
		strSql.append(" ORDER BY ").append(W83aImpugnacionesBD.vista_historial_tramitacion).append(".").append(W83aImpugnacionesBD.fecha_alta_tramite).append( " ASC ");

		params.add(new String(cod[0]));		
		params.add(new Integer(cod[1]));
		params.add(new Integer(cod[2]));
		
		List listaTramites = W83aDataBase.executeQuery(strSql.toString(),params,W83aTramiteImpugnacionBean.class,null, null);
			
		W83aImpugnacionBean resultado=new W83aImpugnacionBean();
		resultado.setListaTramites(listaTramites);
		return resultado;
}

		/* (non-Javadoc)
	 * @see w83a.w83aDAO.W83aIImpugnacionesDAO#obtenerDocsImpugnacion(java.lang.String)
	 */
	public W83aImpugnacionBean obtenerDocsImpugnacion(String codSelec, String idioma) throws Exception {
		String [] codImpugnacion=codSelec.split("_");

		
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83aImpugnacionesBD.id_docu_041).append(", ");
		strSql.append(W83aImpugnacionesBD.nomb_docu_041).append(", ");
		strSql.append(W83aImpugnacionesBD.docu_041).append(", ");
		strSql.append(W83aImpugnacionesBD.c_territ_041).append(", ");
		strSql.append(W83aImpugnacionesBD.ano_impug_041).append(", ");
		strSql.append(W83aImpugnacionesBD.n_impug_041).append(", ");
		strSql.append(W83aImpugnacionesBD.tp_doc_041).append(", ");
		strSql.append(W83aTramitesBD.nomTramite_Cast).append(", ");
		strSql.append(W83aTramitesBD.nomTramite_Eusk).append(", ");
		strSql.append(W83aFasesBD.descripcion).append(", ");
		strSql.append(W83aFasesBD.descripcion_eusk).append(", ");
		strSql.append(W83aImpugnacionesBD.num_reg_041).append(", TO_CHAR(  ");
		strSql.append(W83aImpugnacionesBD.f_reg_041).append(",?) AS ").append(W83aImpugnacionesBD.f_reg_041).append(", ");
		strSql.append(W83aPreavisosBD.desc_cas_069).append(", ");
		strSql.append(W83aPreavisosBD.desc_eus_069).append(", ");
		strSql.append(W83aImpugnacionesBD.usuario_041);

		strSql.append(" FROM ").append(W83aImpugnacionesBD.vistaDocsImpug);
		
		
		strSql.append(" WHERE ").append(W83aImpugnacionesBD.c_territ_041).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aImpugnacionesBD.ano_impug_041).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aImpugnacionesBD.n_impug_041).append(" = ?");
		
		
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(idioma));
		params.add(new String(codImpugnacion[0]));		
		params.add(new Integer(codImpugnacion[1]));
		params.add(new Integer(codImpugnacion[2]));
		
		List listaDocumentos = W83aDataBase.executeQuery(strSql.toString(),params,W83aDocBeanImpug.class,null, null);
		
		W83aImpugnacionBean resultado=new W83aImpugnacionBean();
		resultado.setListaDocs(listaDocumentos);
		return resultado;

		
	
	}

	
	/* (non-Javadoc)
	 * @see w83a.w83aDAO.W83aIImpugnacionesDAO#obtenerHistorialImpugnacion(java.lang.String)
	 */
	public W83aImpugnacionBean obtenerHistorialImpugnacion(String codSelec,String idioma)
			throws Exception {
		
		String [] codImpugnacion=codSelec.split("_");
		
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		
		strSql.append(" TO_CHAR(").append(W83aImpugnacionesBD.factu_073).append(",?) AS ").append(W83aImpugnacionesBD.factu_073).append(", ");
			
		
		//TODO cambiar a que llegue el idioma
		strSql.append(W83aImpugnacionesBD.desc_cas_073).append(" AS DESCRIPCIONC , ");
		strSql.append(W83aImpugnacionesBD.desc_eus_073).append(" AS DESCRIPCIONE , ");

		strSql.append(W83aImpugnacionesBD.usua_073);

		
		strSql.append(" FROM ").append(W83aImpugnacionesBD.impugncion_historial_Synonym);
		
		strSql.append(" WHERE ").append(W83aImpugnacionesBD.c_territ_073).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aImpugnacionesBD.ano_impug_073).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aImpugnacionesBD.n_impug_073).append(" = ?");
		strSql.append(" ORDER BY ").append(W83aImpugnacionesBD.impugncion_historial_Synonym).append(".").append(W83aImpugnacionesBD.factu_073).append( " DESC ");
		if(idioma.equals(W83aClsConstantes.CONSTANTE_CASTELLANO))
		{
			params.add(W83aClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO);
		}else{
			params.add(W83aClsConstantes.FORMATO_FECHA_COMPLETA_EUSKARA);
		}
		
		params.add(new String(codImpugnacion[0]));		
		params.add(new Integer(codImpugnacion[1]));
		params.add(new Integer(codImpugnacion[2]));
		
		List listaHistorial = W83aDataBase.executeQuery(strSql.toString(),params,W83aHistorialImpugnacionBean.class,null, null);
		
		W83aImpugnacionBean resultado=new W83aImpugnacionBean();
		resultado.setListaHistorial(listaHistorial);
		return resultado;	
		
	}

	

	/* (non-Javadoc)
	 * @see w83a.w83aDAO.W83aIImpugnacionesDAO#descargarDocumento(java.lang.String)
	 */
	public W83aDocBean descargarDocumento(String param) throws Exception {
		
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83aImpugnacionesBD.nomb_docu_041).append(",");
		strSql.append(W83aImpugnacionesBD.long_docu_041).append(",");
		strSql.append(W83aImpugnacionesBD.docu_041);
		strSql.append(" FROM ").append(W83aImpugnacionesBD.impugnaciones_docsView);
		//TODO cambiar por id_doc_037
		strSql.append(" WHERE ").append(W83aImpugnacionesBD.id_docu_041).append(" = ?");
		
		params.add(param);		
		
		List listaDocumentos = W83aDataBase.executeQuery(strSql.toString(),params,W83aDocBean.class,null, "impugnaciones");
		
		if (listaDocumentos.size()>0)
			return (W83aDocBean)listaDocumentos.get(0);
		else
			throw new Exception("No existe ese documento");

		

	}

	/* (non-Javadoc)
	 * @see w83a.w83aDAO.W83aIImpugnacionesDAO#buscarSindicatos(w83a.w83aBeans.W83aImpugnacionBean)
	 */
	public List buscarSindicatos(w83a.w83aBeans.W83aImpugnacionBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83aSindicatosBD.codSindicato).append(", ");
		strSql.append(W83aSindicatosBD.descSindicatoCast).append(", ");
		strSql.append(W83aSindicatosBD.descSindicatoEusk).append(", ");
		
		strSql.append(" FROM ").append(W83aSindicatosBD.sindicatosVista);
		strSql.append(" INNER JOIN ").append(W83aSindicatosImpugnacionBD.sindImpugView);
		
		strSql.append(" ON (");
		strSql.append(W83aSindicatosImpugnacionBD.codSind).append(" = ").append(W83aSindicatosBD.codSindicato);
		
		strSql.append(" WHERE ").append(W83aSindicatosImpugnacionBD.territorio).append(" = ? ");
		strSql.append(" AND ").append(W83aSindicatosImpugnacionBD.anioImpug).append(" = ?");
		strSql.append(" AND ").append(W83aSindicatosImpugnacionBD.numimpug).append(" = ?");
		params.add(param.getTerritorioImpugnacion());
		params.add(param.getAnyoImpugnacion());
		params.add(param.getNumImpugnacion());
		
		
		List lista = W83aDataBase.executeQuery(strSql.toString(),params,W83aSindicatosBean.class,null, param.getIdioma());
		
		return lista;	
	}
	
	


	
}

